/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.write.biome;

import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

public class BiomeBlendCalculator
implements IBlockDisplayReader {
    private World original;

    public void setWorld(World original) {
        this.original = original;
    }

    public TileEntity func_175625_s(BlockPos blockPos) {
        return this.original.func_175625_s(blockPos);
    }

    public BlockState func_180495_p(BlockPos blockPos) {
        return this.original.func_180495_p(blockPos);
    }

    public FluidState func_204610_c(BlockPos blockPos) {
        return this.original.func_204610_c(blockPos);
    }

    public float func_230487_a_(Direction direction, boolean bl) {
        return this.original.func_230487_a_(direction, bl);
    }

    public WorldLightManager func_225524_e_() {
        return this.original.func_225524_e_();
    }

    public int func_225525_a_(BlockPos blockPos, ColorResolver colorResolver) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        int redAccumulator = 0;
        int greenAccumulator = 0;
        int blueAccumulator = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                mutableBlockPos.func_181079_c(x + i, y, z + j);
                Biome biome = this.original.func_226691_t_((BlockPos)mutableBlockPos);
                int colorSample = colorResolver.getColor(biome, (double)mutableBlockPos.func_177958_n(), (double)mutableBlockPos.func_177952_p());
                redAccumulator += colorSample >> 16 & 0xFF;
                greenAccumulator += colorSample >> 8 & 0xFF;
                blueAccumulator += colorSample & 0xFF;
            }
        }
        int red = redAccumulator / 9;
        int green = greenAccumulator / 9;
        int blue = blueAccumulator / 9;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

